// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "hw_di.h"
#include "hw_vi.h"

#define DICVR_CVRINT	0x00000004
#define DICVR_CVRINTMSK	0x00000002
#define DICVR_CVR	0x00000001

#define DICR_RW		0x00000004
#define DICR_DMA	0x00000002
#define DICR_TSTART	0x00000001

#define DISR_BRK	0x00000001
#define DISR_DEINTMSK	0x00000002
#define DISR_DEINT	0x00000004
#define DISR_TCINTMSK	0x00000008
#define DISR_TCINT	0x00000010
#define DISR_BRKINTMSK	0x00000020
#define DISR_BRKINT	0x00000040

//combined status+error
#define DVD_STATUS_READY		0x00000000
#define DVD_STATUS_COVER_OPENED		0x01000000
#define DVD_STATUS_DISK_CHANGE		0x02062800
#define DVD_STATUS_NO_DISK		0x03023a00
#define DVD_STATUS_MOTOR_STOP		0x04020400
#define DVD_STATUS_DISK_ID_NOT_READ	0x05020401

#define DVD_ERROR_NO_ERROR		0x00000000
#define DVD_ERROR_MOTOR_STOPPED		0x00020400
#define DVD_ERROR_DISK_ID_NOT_READ	0x00020401
#define DVD_ERROR_MEDIUM_NOT_PRESENT	0x00023a00
#define DVD_ERROR_SEEK_INCOMPLETE	0x00030200
#define DVD_ERROR_UNRECOVERABLE_READ	0x00031100
#define DVD_ERROR_INVALID_COMMAND	0x00052000
#define DVD_ERROR_BLOCK_OUT_OF_RANGE	0x00052100
#define DVD_ERROR_INVALID_FIELD		0x00052400
#define DVD_ERROR_MEDIUM_CHANGED	0x00062800

#define SETFLAGS(old, flags, set) ((set) ? (old) | (flags) : (old) & ~(flags))

#define DDEGUB if(g::dvd_log) DEGUB
#define VDDEGUB if(g::verbose && g::dvd_log) DEGUB

DWORD HwDI::rw_cfg(Hardware *, WORD offset) {
	MYASSERT(offset == 0x6024);
	DDEGUB("DVD CFG read: 0x%08X\n", 0);
	return 0;
}

void HwDI::ww_cvr(Hardware *h, WORD offset, DWORD data) {
	MYASSERT(offset == 0x6004);
	DDEGUB("DVD CVR write: 0x%08X\n", data);
	if(data & DICVR_CVRINT)
		data &= ~DICVR_CVRINT;
	h->hww(offset, data);
}
DWORD HwDI::rw_cvr(Hardware *h, WORD offset) {
	MYASSERT(offset == 0x6004);
	DWORD data = h->hrw(offset);
	data = SETFLAGS(data, DICVR_CVR, h->m_lidopen);
	DDEGUB("DVD CVR read: 0x%08X\n", data);
	return data;
}

void HwDI::ww_sr(Hardware *h, WORD offset, DWORD data) {
	MYASSERT(offset == 0x6000);
	DDEGUB("DVD SR write: 0x%08X + 0x%08X => ", h->hrw(offset), data);
	if(data & 1) {  //Break Request
		DDEGUB("Break Request! ");
		data = CLEARINTFLAGS(h->hrw(offset), data | 0x40, 0x15);
		if(data & 0x20)
			h->interrupt.raise(INTEX_DI, "DVD Break");
	} else {
		data = CLEARINTFLAGS(h->hrw(offset), data, 0x55);
	}
	DDEGUB("0x%08X\n", data);
	h->hww(offset, data);
}

void HwDI::ww_cr(Hardware *h, WORD offset, DWORD data) {
	MYASSERT(offset == 0x601C);
	DDEGUB("DVD CR write: 0x%08X\n", data);

#define DVD_MAXSIZE 712880*2048
	DWORD action = data, command = h->hrw(PR_DICMDBUF0);
	if(action & DICR_TSTART) {
		DWORD offset, slen, daddress, dlen;
		switch(getbitsw(command, 0, 7)) {
		case 0xA8:  //Read
			switch(command) {
		case 0xA8000000:
			DDEGUB("DVD Read");
			break;
		case 0xA8000040:
			DDEGUB("DVD Read ID");
			break;
		default:
			DDEGUB("DVD Read UNKNOWN");
			//if(g::bouehr)
			throw bouehr_exception("Unknown DVD Read variant");
			}

			//Load data
			offset = h->hrw(PR_DICMDBUF1) << 2;
			slen = h->hrw(PR_DICMDBUF2);
			daddress = h->hrw(PR_DIMAR);
			dlen = h->hrw(PR_DILENGH);
			DDEGUB(": offset=0x%08X, slen=0x%X, daddress=0x%08X, dlen=0x%X\n",
				offset, slen, daddress, dlen);

			//check for lid, too
			if(!h->gcmfile.isOpen()) {  //Check for GCM  //needs fixing, lots of it
				DDEGUB("DVD Read without GCM!\n");
				DWORD disr = h->hrw(PR_DISR);
				h->hww(PR_DISR, disr | DISR_DEINT);	//Big Phat Error? ;)
				if(disr & DISR_DEINTMSK)
					h->interrupt.raise(INTEX_DI, "DVD Read error");
				h->m_dvdstatus = DVD_STATUS_NO_DISK;
				return;
			}
			if(!(action & DICR_DMA))
				throw hardware_fatal_exception("DVD Read without DMA!");

			if(slen != dlen)
				throw hardware_fatal_exception("DVD Read size mismatch!");
			//if((slen & 0xF) != 0 || (daddress & 0xF) != 0 || (dlen & 0xF) != 0)
			//throw hardware_fatal_exception("DVD Unaligned transfer!");
			if(offset >= DVD_MAXSIZE || offset + slen > DVD_MAXSIZE)
				throw hardware_fatal_exception("DVD Read WAY out of range!");

			{	//Do the read
				uint gcm_size;
				HWGLE(h->gcmfile.size(&gcm_size));
				gcm_size = MIN(gcm_size, DVD_MAXSIZE);

				Container<BYTE> buffer(slen);
				DWORD adjusted_len;
				if(offset + slen > gcm_size) {
					adjusted_len = (offset < gcm_size) ? gcm_size - offset : 0;
					ZeroMemory(buffer + adjusted_len, slen - adjusted_len);
				} else
					adjusted_len = slen;
				if(offset < gcm_size) {
					HWGLE(h->gcmfile.seek(offset));
					HWGLE(h->gcmfile.read(buffer, adjusted_len));
					if(adjusted_len != slen) {
						DDEGUB("  Partially out of range\n");
					}
				} else {
					DDEGUB("  Totally out of range\n");
					MYASSERT(adjusted_len == 0);
				}
				h->m.write_cached(daddress, slen, buffer);
			}
			h->m_visi_limit = h->m_cc.cycles + VISI_TIMEOUT;	//HACK
			break;
			case 0xAB:  //Seek
				if(command != 0xAB000000) {
					DEGUB("DVD Command: 0x%08X ", command);
					throw bouehr_exception("Unknown DVD command!");
				}
				if(!h->gcmfile.isOpen()) {  //Check for GCM  //needs fixing
					DDEGUB("DVD Seek without GCM!\n");
					DWORD disr = h->hrw(PR_DISR);
					h->hww(PR_DISR, disr | DISR_DEINT);	//Big Phat Error? ;)
					if(disr & DISR_DEINTMSK)
						h->interrupt.raise(INTEX_DI, "DVD Seek error");
					h->m_dvdstatus = DVD_STATUS_NO_DISK;
					return;
				}

				//Load data
				offset = h->hrw(PR_DICMDBUF1) << 2;
				slen = h->hrw(PR_DICMDBUF2);
				daddress = h->hrw(PR_DIMAR);
				dlen = h->hrw(PR_DILENGH);
				DDEGUB("DVD Seek: offset=0x%08X, slen=0x%X, daddress=0x%08X, dlen=0x%X\n",
					offset, slen, daddress, dlen);
				break;
			case 0xE0:	//Request Error	//needs fixing
				DDEGUB("DVD Request Error\n");
				if(action != 1) {
					for(WORD i=0; i<=0x24 / 4; i++) {
						DEGUB("%08X  ", h->hrw(0x6000 + i*4));
					}
					DEGUB("\n");
					throw hardware_fatal_exception("DVD Unknown Request Error variant!");
				}
				h->hww(0x6020, h->m_dvdstatus);
				break;
			case 0xE3:  //Stop Motor
				if(command != 0xE3000000) {
					DDEGUB("DVD Command: 0x%08X ", command);
					throw bouehr_exception("Unknown DVD command!");
				}
				DDEGUB("DVD Stop Motor\n");
				break;
			case 0xE4:  //Audio	//probably needs fixing
				DDEGUB("DVD Audio");
				if(command != 0xE4000000) {
					DDEGUB(" 0x%08X", command);
				} else {
					DDEGUB(" Disable");
				}
				DDEGUB("\n");
				break;
			case 0x12:	//Drive Info  //surely needs fixing
				DDEGUB("DVD Drive Info (nerfed)");
				offset = h->hrw(PR_DICMDBUF1) << 2;
				slen = h->hrw(PR_DICMDBUF2);
				daddress = h->hrw(PR_DIMAR);
				dlen = h->hrw(PR_DILENGH);
				DDEGUB(": offset=0x%08X, slen=0x%X, daddress=0x%08X, dlen=0x%X\n",
					offset, slen, daddress, dlen);
				if(!(action & DICR_DMA))
					throw hardware_fatal_exception("DVD Read without DMA!");
				if(slen != dlen) {
					throw bouehr_exception("slen != dlen in DVD command!");
				}
				memset(h->m.getp_translated(daddress, dlen), 0, dlen);  //tmode for all sdk stuff
				break;
			default:
				DEGUB("Unknown DVD Command: %08X  Action: %08X\n", command, action);
				for(WORD i=0; i<=0x24 / 4; i++) {
					DEGUB("%08X  ", h->hrw(0x6000 + i*4));
				}
				DEGUB("\n");
				//if(g::bouehr)
				throw bouehr_exception("Unknown DVD command!");
		}
		VDDEGUB("@ cycle %I64u\n", h->m_cc.cycles);
	}
	//Acknowledge
	if(action & DICR_DMA)
		h->hww(PR_DILENGH, 0); //Experimental and undocumented, but working :)

	DWORD disr = h->hrw(PR_DISR);
	h->hww(PR_DISR, disr | DISR_TCINT);
	if(disr & DISR_TCINTMSK)
		h->interrupt.raise(INTEX_DI, "DVD Transfer Complete");

	action &= ~DICR_TSTART;
	h->hww(offset, action);

	h->m_dvdstatus = DVD_STATUS_READY;
}

void Hardware::setlid(bool open) {
	if(open != m_lidopen) {
		DWORD cvr = hrw(0x6004);
		m_lidopen = open;
		cvr = SETFLAGS(cvr, DICVR_CVR, open) | DICVR_CVRINT;
		hww(0x6004, cvr);
		DDEGUB("DVD Lid %sed\n", open ? "open" : "clos");
		if(cvr & DICVR_CVRINTMSK) {
			DDEGUB("DVD Lid interrupt raised\n");
			interrupt.raise(INTEX_DI, "DVD Lid");
		}
	}
}

bool Hardware::loadgcm(const char *gcmname) {
	MYASSERT(!m_lidopen);
	MYASSERT(!gcmfile.isOpen());
	unloadgcm();
	DDEGUB("Loading GCM: %s\n", gcmname);
	TGLE(gcmfile.open(gcmname));
	return true;
}

void Hardware::unloadgcm() {
	gcmfile.close();
}

/*//stuff for reading byteswapped stuctures
#define BYTESWAPPED_GCM_HEADER_1(name, array, single) name(GCM_HEADER_1)\
array(char, game_id, 3)\
single(char, country_code)\
array(char, makercode, 2)\
array(char, _padding1, 22)\
single(DWORD, magic)\
array(char, gamename, 0x400-0x20)\
single(DWORD, db_discpos)\
single(DWORD, db_memaddr)\
array(char, _padding2, 0x18)\
single(DWORD, dol_discpos)\
single(DWORD, fst_discpos)\
single(DWORD, fst_size)\
single(DWORD, fst_maxsize)\

#define BDS_INIT1(naem) struct naem {\
private: vector
public: naem() : {}\

#define BDS_ARRAY(type, id, length) type id[length];
#define BDS_SINGLE(type, id) type id;
#define BYTESWAPPED_DECLARE_STRUCT(source) source(BDS_INIT1, BDS_ARRAY, BDS_SINGLE) }

BYTESWAPPED_DECLARE_STRUCT(BYTESWAPPED_DECLARE_STRUCT);*/

struct GCM_header_1 {
	char game_id[3];
	char country_code;
	char makercode[2];
	char _padding1[22];
	DWORD magic;	//big endian...
	char gamename[0x400-0x20];
	DWORD db_discpos; //big endian...
	DWORD db_memaddr; //big endian...
	char _padding2[0x18];
	DWORD dol_discpos;  //big endian...
	DWORD fst_discpos;  //big endian...
	DWORD fst_size; //big endian...
	DWORD fst_maxsize;  //big endian...
};

bool Hardware::do_gcmload_hle() {
	if(!gcmfile.isOpen())
		return true;

	GCM_header_1 gcmh_1;
	TGLE(gcmfile.seek(0));

	MYASSERT(sizeof(gcmh_1) == 0x430);
	TGLE(gcmfile.read(&gcmh_1, sizeof(gcmh_1)));
	{
		char gamecode[5];
		for(int i=0; i<4; i++) {
			BYTE b = ((BYTE*)&gcmh_1)[i];
			gamecode[i] = (b == 0) ? ' ' : b;
		}
		gamecode[4] = 0;
		DEGUB("HLE-Loading GCM. Code: %s\nName: %s\n", gamecode, gcmh_1.gamename);
	}

#define SWAP_DWORD(i) { i = swapw(i); }
#define GCMH1_DWORDS(macro) \
	macro(gcmh_1.magic)\
	macro(gcmh_1.db_discpos)\
	macro(gcmh_1.db_memaddr)\
	macro(gcmh_1.dol_discpos)\
	macro(gcmh_1.fst_discpos)\
	macro(gcmh_1.fst_size)\
	macro(gcmh_1.fst_maxsize)\

	GCMH1_DWORDS(SWAP_DWORD);
	GCMH1_DWORDS(DUMPDWORD);

	DWORD fst_dst = m.prw(0x34) - gcmh_1.fst_maxsize;
	m.pww(0x34, fst_dst);
	m.pww(0x38, fst_dst);
	m.pww(0x3C, gcmh_1.fst_maxsize);

	switch(gcmh_1.country_code) {
	case 'P':
	case 'X':	//unofficial, what gcm has this?
		m.pww(0xCC, 1); //PAL
		break;
	case 'E':
	case 'J':
	case 'U':	//cubed-gcworld
	case 'C':	//Team Symbiote Wii DVD Player beta 1.0
		m.pww(0xCC, 0); //NTSC
		break;
	default:
		DEGUB("Country code: %c\n", gcmh_1.country_code);
		throw generic_fatal_exception("Unknown country code!");
	}

	TGLE(gcmfile.seek(gcmh_1.fst_discpos));
	TGLE(gcmfile.read(m.getp_translated(fst_dst, gcmh_1.fst_size), gcmh_1.fst_size));
	return true;
}
